
-- Create a new table called 'EST_PED_VD_PAG_CHEQUE' in schema 
-- Drop the table if it already exists
IF OBJECT_ID('EST_PED_VD_PAG_CHEQUE', 'U') IS  NULL
BEGIN

    -- Create the table in the specified schema
    CREATE TABLE EST_PED_VD_PAG_CHEQUE
    (
        [CD_CTR] 		int IDENTITY(1,1) NOT NULL, -- Primary Key column
        [PAG_CD_CTR] 	int NULL,
        [CPF] 				[varchar](15)  COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS 	NULL,
        [CMC7] 				[varchar](35)  COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS 	NULL,
        [DT_CHEQUE] 		[datetime]		NULL,
        [DT_VENCTO] 		[datetime] 		NOT NULL,
        [ANO_CHQ] 			[varchar](4) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL,
        [MES_ANO_CNT_CHQ] 	[varchar](7) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NULL,
        CONSTRAINT PK_EST_PED_VD_PAG_CHEQUE PRIMARY KEY CLUSTERED 
        (
            CD_CTR ASC
        )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
    )ON [PRIMARY]

    ALTER TABLE EST_PED_VD_PAG_CHEQUE  WITH CHECK ADD  CONSTRAINT FK_EST_PED_VD_PAG_CHEQUE_EST_PED_VD_PAG FOREIGN KEY(PAG_CD_CTR) REFERENCES EST_PED_VD_PAG (CD_CTR)
	ALTER TABLE EST_PED_VD_PAG_CHEQUE CHECK CONSTRAINT FK_EST_PED_VD_PAG_CHEQUE_EST_PED_VD_PAG;

END

    
